local function add_structure(f)
	if(f) then
		f.shape_table_data = 
		{
			{
				file  	    = f.ShapeName,
				life	    = f.Life,
				username    = f.Name,
				desrt       = f.ShapeNameDestr or "self",
			        classname   = f.classname   or "lLandVehicle",
				positioning = f.positioning or "ONLYHEIGTH"	--available: {"BYNORMAL", "ONLYHEIGTH", "BY_XZ", "ADD_HEIGTH"}
			}
		}
		if f.ShapeNameDestr then
			f.shape_table_data[#f.shape_table_data + 1] = 
			{
				name  = f.ShapeName,
				file  = f.ShapeNameDestr,	
			}
		end
		
		
		--f.mapclasskey = "P0091000022";
		if f.keynum then
			f.mapclasskey = f.keynum
		else
			f.mapclasskey = "P0091000076"
		end

		f.attribute = {wsType_Static, wsType_Standing} -- if 'attribute' == nil then insertion will be aborted

		if f.conf_fire then
			f.visual = f.conf_fire
		end

		if f.conf_animation then
			f.animation_arguments = f.conf_animation
		end
		
		add_surface_unit(f)
		GT = nil;
	else
		error("Can't add Riza24 structure(FC4_Park.lua)")
	end;
end

--****************************************************************
-- Riz24 FC4_Park
--
-- FC3/4のSpawn用のPark 2.0/2.5/3.0/3.5m
--
add_structure({
	Name 		 	=	"R24G FC4 Park",
	DisplayName  	=	_("R24G FC4 Park"),
	ShapeName	 	=	"Riz24_FC4_Park200",
	desrt		 	=	"Riz24_FC4_Park200",
	Life		 	=	10000,
	Rate		 	=	100,
	--category     	=	'Fortification',
	SeaObject	 	=	false,
	isPutToWater 	=	false,
	positioning  	=	"BYNORMAL",
	--classname    	=	"lStandartStructure",
	category     =  'Heliport',
	classname    =  "lHeliport",
	numParking		= 4,
	Plane_Num_		= 0,	-- Real value = 0 (4 Helicopters )
	Helicopter_Num_	= 4,	-- Real value = 4 Helicopters

	--fire
	conf_fire = {
		fire_size = 0, --relative burning size
		fire_pos = {0,0,0},
		fire_time = 0, --burning time (seconds)
	},
	time_agony = 180,

	-- animation
	conf_animation = {
	    headlights = 1,
	},
})

--
-- FC4のSpawn用の単独部分。スロープなし
--
add_structure({
	Name 		 	=	"R24G FC4 Plate",
	DisplayName  	=	_("R24G FC4 Plate"),
	ShapeName	 	=	"Riz24_FC4_Plate",
	desrt		 	=	"Riz24_FC4_Plate",
	Life		 	=	10000,
	Rate		 	=	100,
	--category     	=	'Fortification',
	SeaObject	 	=	true,
	isPutToWater 	=	true,
	positioning  	=	"BYNORMAL",
	--classname    	=	"lStandartStructure",
	category     =  'Heliport',
	classname    =  "lHeliport",
	numParking		= 4,
	Plane_Num_		= 0,	-- Real value = 0 (4 Helicopters )
	Helicopter_Num_	= 4,	-- Real value = 4 Helicopters

	--fire
	conf_fire = {
		fire_size = 0, --relative burning size
		fire_pos = {0,0,0},
		fire_time = 0, --burning time (seconds)
	},
	time_agony = 180,

	-- animation
	conf_animation = {
	    headlights = 1,
	},
})

--
-- FC4のSpawn用の単独部分。スロープなし
--
add_structure({
	Name 		 	=	"R24G FC4 Plate LEVEL",
	DisplayName  	=	_("R24G FC4 Plate LEVEL"),
	ShapeName	 	=	"Riz24_FC4_Plate",
	desrt		 	=	"Riz24_FC4_Plate",
	Life		 	=	10000,
	Rate		 	=	100,
	--category     	=	'Fortification',
	SeaObject	 	=	true,
	isPutToWater 	=	true,
	positioning  	=	"ONLYHEIGHT",
	--classname    	=	"lStandartStructure",
	category     =  'Heliport',
	classname    =  "lHeliport",
	numParking		= 4,
	Plane_Num_		= 0,	-- Real value = 0 (4 Helicopters )
	Helicopter_Num_	= 4,	-- Real value = 4 Helicopters
	--fire
	conf_fire = {
		fire_size = 0, --relative burning size
		fire_pos = {0,0,0},
		fire_time = 0, --burning time (seconds)
	},
	time_agony = 180,

	-- animation
	conf_animation = {
	    headlights = 1,
	},
})


-- ***************************************************************************
-- ***************************************************************************
-- ***************************************************************************
-- ***************************************************************************
-- ***************************************************************************
-- ***************************************************************************

--[[
add_structure({
	Name 		 	=	"R24G FC4 Park 250",
	DisplayName  	=	_("R24G FC4 Park 250"),
	ShapeName	 	=	"Riz24_FC4_Park250",
	desrt		 	=	"Riz24_FC4_Park250",
	Life		 	=	10000,
	Rate		 	=	100,
	--category     	=	'Fortification',
	SeaObject	 	=	false,
	isPutToWater 	=	false,
	positioning  	=	"BYNORMAL",
	classname    	=	"lStandartStructure",
	category     =  'Heliport',
	--classname    =  "lHeliport",
	numParking   =  1,
	--fire
	conf_fire = {
		fire_size = 0, --relative burning size
		fire_pos = {0,0,0},
		fire_time = 0, --burning time (seconds)
	},
	time_agony = 180,

	-- animation
	conf_animation = {
	    headlights = 1,
	},
})

add_structure({
	Name 		 	=	"R24G FC4 Park 300",
	DisplayName  	=	_("R24G FC4 Park 300"),
	ShapeName	 	=	"Riz24_FC4_Park300",
	desrt		 	=	"Riz24_FC4_Park300",
	Life		 	=	10000,
	Rate		 	=	100,
	--category     	=	'Fortification',
	SeaObject	 	=	false,
	isPutToWater 	=	false,
	positioning  	=	"BYNORMAL",
	classname    	=	"lStandartStructure",
	category     =  'Heliport',
	--classname    =  "lHeliport",
	numParking   =  1,
	--fire
	conf_fire = {
		fire_size = 0, --relative burning size
		fire_pos = {0,0,0},
		fire_time = 0, --burning time (seconds)
	},
	time_agony = 180,

	-- animation
	conf_animation = {
	    headlights = 1,
	},
})

add_structure({
	Name 		 	=	"R24G FC4 Park 350",
	DisplayName  	=	_("R24G FC4 Park 350"),
	ShapeName	 	=	"Riz24_FC4_Park350",
	desrt		 	=	"Riz24_FC4_Park350",
	Life		 	=	10000,
	Rate		 	=	100,
	--category     	=	'Fortification',
	SeaObject	 	=	false,
	isPutToWater 	=	false,
	positioning  	=	"BYNORMAL",
	classname    	=	"lStandartStructure",
	category     =  'Heliport',
	--classname    =  "lHeliport",
	numParking   =  1,
	--fire
	conf_fire = {
		fire_size = 0, --relative burning size
		fire_pos = {0,0,0},
		fire_time = 0, --burning time (seconds)
	},
	time_agony = 180,

	-- animation
	conf_animation = {
	    headlights = 1,
	},
})

add_structure({
	Name 		 	=	"R24G FC4 Park 100",
	DisplayName  	=	_("R24G FC4 Park 100"),
	ShapeName	 	=	"Riz24_FC4_Park100",
	desrt		 	=	"Riz24_FC4_Park100",
	Life		 	=	10000,
	Rate		 	=	100,
	--category     	=	'Fortification',
	SeaObject	 	=	false,
	isPutToWater 	=	false,
	positioning  	=	"BYNORMAL",
	classname    	=	"lStandartStructure",
	category     =  'Heliport',
	--classname    =  "lHeliport",
	numParking   =  1,
	--fire
	conf_fire = {
		fire_size = 0, --relative burning size
		fire_pos = {0,0,0},
		fire_time = 0, --burning time (seconds)
	},
	time_agony = 180,

	-- animation
	conf_animation = {
	    headlights = 1,
	},
})

--
-- FC4のSpawn用の単独部分。スロープなし
--
add_structure({
	Name 		 	=	"R24G FC4 Plate S",
	DisplayName  	=	_("R24G FC4 Plate S"),
	DisplayNameShort  	=	_("FC4 Plate S"),
	ShapeName	 	=	"Riz24_FC4_Plate",
	desrt		 	=	"Riz24_FC4_Plate",
	Life		 	=	2000,
	Rate		 	=	100,
	SeaObject	 	=	true,
	isPutToWater 	=	true,
	positioning  	=	"BYNORMAL",
	category     	=	'Fortification',
	classname    	=	"lStandartStructure",
	--category     =  'Heliport',
	--classname    =  "lHeliport",
})


--****************************************************************
-- R24G FC4_Park(ONLYHEIGTH)
--
-- FC3/4のSpawn用のPark 2.0/2.5/3.0/3.5m
--
add_structure({
	Name 		 	=	"R24G FC4 Park LEVEL",
	DisplayName  	=	_("R24G FC4 Park LEVEL"),
	ShapeName	 	=	"Riz24_FC4_Park200",
	desrt		 	=	"Riz24_FC4_Park200",
	Life		 	=	10000,
	Rate		 	=	100,
	--category     	=	'Fortification',
	SeaObject	 	=	false,
	isPutToWater 	=	false,
	positioning  	=	"ONLYHEIGTH",
	classname    	=	"lStandartStructure",
	category     =  'Heliport',
	--classname    =  "lHeliport",
	numParking   =  1,
	--fire
	conf_fire = {
		fire_size = 0, --relative burning size
		fire_pos = {0,0,0},
		fire_time = 0, --burning time (seconds)
	},
	time_agony = 180,

	-- animation
	conf_animation = {
	    headlights = 1,
	},
})

add_structure({
	Name 		 	=	"R24G FC4 Park 250 LEVEL",
	DisplayName  	=	_("R24G FC4 Park 250 LEVEL"),
	ShapeName	 	=	"Riz24_FC4_Park250",
	desrt		 	=	"Riz24_FC4_Park250",
	Life		 	=	10000,
	Rate		 	=	100,
	--category     	=	'Fortification',
	SeaObject	 	=	false,
	isPutToWater 	=	false,
	positioning  	=	"ONLYHEIGTH",
	classname    	=	"lStandartStructure",
	category     =  'Heliport',
	--classname    =  "lHeliport",
	numParking   =  1,
	--fire
	conf_fire = {
		fire_size = 0, --relative burning size
		fire_pos = {0,0,0},
		fire_time = 0, --burning time (seconds)
	},
	time_agony = 180,

	-- animation
	conf_animation = {
	    headlights = 1,
	},
})

add_structure({
	Name 		 	=	"R24G FC4 Park 300 LEVEL",
	DisplayName  	=	_("R24G FC4 Park 300 LEVEL"),
	ShapeName	 	=	"Riz24_FC4_Park300",
	desrt		 	=	"Riz24_FC4_Park300",
	Life		 	=	10000,
	Rate		 	=	100,
	--category     	=	'Fortification',
	SeaObject	 	=	false,
	isPutToWater 	=	false,
	positioning  	=	"ONLYHEIGTH",
	classname    	=	"lStandartStructure",
	category     =  'Heliport',
	--classname    =  "lHeliport",
	numParking   =  1,
	--fire
	conf_fire = {
		fire_size = 0, --relative burning size
		fire_pos = {0,0,0},
		fire_time = 0, --burning time (seconds)
	},
	time_agony = 180,

	-- animation
	conf_animation = {
	    headlights = 1,
	},
})

add_structure({
	Name 		 	=	"R24G FC4 Park 350 LEVEL",
	DisplayName  	=	_("R24G FC4 Park 350 LEVEL"),
	ShapeName	 	=	"Riz24_FC4_Park350",
	desrt		 	=	"Riz24_FC4_Park350",
	Life		 	=	10000,
	Rate		 	=	100,
	--category     	=	'Fortification',
	SeaObject	 	=	false,
	isPutToWater 	=	false,
	positioning  	=	"ONLYHEIGTH",
	classname    	=	"lStandartStructure",
	category     =  'Heliport',
	--classname    =  "lHeliport",
	numParking   =  1,
	--fire
	conf_fire = {
		fire_size = 0, --relative burning size
		fire_pos = {0,0,0},
		fire_time = 0, --burning time (seconds)
	},
	time_agony = 180,

	-- animation
	conf_animation = {
	    headlights = 1,
	},
})

add_structure({
	Name 		 	=	"R24G FC4 Park 100 LEVEL",
	DisplayName  	=	_("R24G FC4 Park 100 LEVEL"),
	ShapeName	 	=	"Riz24_FC4_Park100",
	desrt		 	=	"Riz24_FC4_Park100",
	Life		 	=	10000,
	Rate		 	=	100,
	--category     	=	'Fortification',
	SeaObject	 	=	false,
	isPutToWater 	=	false,
	positioning  	=	"ONLYHEIGTH",
	classname    	=	"lStandartStructure",
	category     =  'Heliport',
	--classname    =  "lHeliport",
	numParking   =  1,
	--fire
	conf_fire = {
		fire_size = 0, --relative burning size
		fire_pos = {0,0,0},
		fire_time = 0, --burning time (seconds)
	},
	time_agony = 180,

	-- animation
	conf_animation = {
	    headlights = 1,
	},
})

--
-- FC4のSpawn用の単独部分。スロープなし
--
add_structure({
	Name 		 	=	"R24G FC4 Plate LEVEL",
	DisplayName  	=	_("R24G FC4 Plate LEVEL"),
	ShapeName	 	=	"Riz24_FC4_Plate",
	desrt		 	=	"Riz24_FC4_Plate",
	Life		 	=	10000,
	Rate		 	=	100,
	--category     	=	'Fortification',
	SeaObject	 	=	true,
	isPutToWater 	=	true,
	positioning  	=	"ONLYHEIGTH",
	classname    	=	"lStandartStructure",
	category     =  'Heliport',
	--classname    =  "lHeliport",
	numParking   =  1,
	--fire
	conf_fire = {
		fire_size = 0, --relative burning size
		fire_pos = {0,0,0},
		fire_time = 0, --burning time (seconds)
	},
	time_agony = 180,

	-- animation
	conf_animation = {
	    headlights = 1,
	},
})

--
-- FC4のSpawn用の単独部分。スロープなし
--
add_structure({
	Name 		 	=	"R24G FC4 Plate S LEVEL",
	DisplayName  	=	_("R24G FC4 Plate S LEVEL"),
	DisplayNameShort  	=	_("FC4 Plate S"),
	ShapeName	 	=	"Riz24_FC4_Plate",
	desrt		 	=	"Riz24_FC4_Plate",
	Life		 	=	2000,
	Rate		 	=	100,
	SeaObject	 	=	true,
	isPutToWater 	=	true,
	positioning  	=	"ONLYHEIGTH",
	category     	=	'Fortification',
	classname    	=	"lStandartStructure",
	--category     =  'Heliport',
	--classname    =  "lHeliport",
})

]]
